/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import noobanidus.mods.lootr.common.api.IClientOpeners;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.CustomLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.NewTickingData;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.blockentity.RandomizableContainerBlockEntityLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.entity.AbstractMinecartContainerLootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import org.jetbrains.annotations.Nullable;

public interface ILootrInfoProvider
extends ILootrInfo,
IClientOpeners {
    public static ILootrInfoProvider of(class_2338 pos, class_1937 level) {
        if (level.method_8608()) {
            return null;
        }
        class_2586 blockEntity = level.method_8321(pos);
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return null;
    }

    public static ILootrInfoProvider of(class_2621 blockEntity, UUID id) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return new RandomizableContainerBlockEntityLootrInfoProvider(blockEntity, id, ILootrInfo.generateInfoKey(id), null);
    }

    public static ILootrInfoProvider of(class_2621 blockEntity, UUID id, class_2371<class_1799> customInventory) {
        ILootrBlockEntity iLootrBlockEntity = LootrAPI.resolveBlockEntity(blockEntity);
        if (iLootrBlockEntity instanceof ILootrInfoProvider) {
            ILootrBlockEntity provider = iLootrBlockEntity;
            return provider;
        }
        if (blockEntity instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)blockEntity;
            return provider;
        }
        return new RandomizableContainerBlockEntityLootrInfoProvider(blockEntity, id, ILootrInfo.generateInfoKey(id), customInventory);
    }

    public static ILootrInfoProvider of(class_1693 minecart) {
        if (minecart instanceof ILootrInfoProvider) {
            ILootrInfoProvider provider = (ILootrInfoProvider)minecart;
            return provider;
        }
        return new AbstractMinecartContainerLootrInfoProvider(minecart, ILootrInfo.generateInfoKey(minecart.method_5667()));
    }

    @Deprecated
    public static ILootrInfoProvider of(UUID id, class_2338 pos, int containerSize, class_5321<class_52> lootTable, long lootSeed, class_2561 displayName, class_5321<class_1937> dimension, class_2371<class_1799> customInventory, @Deprecated ILootrInfo.LootrInfoType type, @Deprecated LootrBlockType blockType) {
        return new CustomLootrInfoProvider(id, ILootrInfo.generateInfoKey(id), pos, containerSize, lootTable, lootSeed, displayName, dimension, customInventory, type, blockType, BaseLootrInfo.resolveType(blockType, type, null));
    }

    public static ILootrInfoProvider of(UUID id, class_2338 pos, int containerSize, class_5321<class_52> lootTable, long lootSeed, class_2561 displayName, class_5321<class_1937> dimension, class_2371<class_1799> customInventory, ILootrType type) {
        return new CustomLootrInfoProvider(id, ILootrInfo.generateInfoKey(id), pos, containerSize, lootTable, lootSeed, displayName, dimension, customInventory, null, null, type);
    }

    default public int getPhysicalOpenerCount() {
        return -1;
    }

    @Override
    default public Set<UUID> getVisualOpeners() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            return data.getVisualOpeners();
        }
        return null;
    }

    @Override
    default public Set<UUID> getActualOpeners() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            return data.getActualOpeners();
        }
        return null;
    }

    default public boolean hasLootAvailable(class_3222 player) {
        ILootrInventory inventory = LootrAPI.getInventory(this, player);
        if (inventory == null) {
            return false;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i).method_7960()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public IContainerTrigger getTrigger() {
        return null;
    }

    default public void performTrigger(class_3222 player) {
        IContainerTrigger trigger = this.getTrigger();
        if (trigger != null && !this.hasServerOpened((class_1657)player)) {
            trigger.trigger(player, this.getInfoUUID());
        }
    }

    default public void performOpen(class_3222 player) {
    }

    default public void performOpen() {
    }

    default public void performClose(class_3222 player) {
    }

    default public void performClose() {
    }

    default public void performDecay() {
    }

    default public void performRefresh() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            data.refresh();
            data.clearOpeners();
            NewTickingData.getRefreshData().clearTicking(LootrAPI.getServer(), this.getInfoUUID());
            this.markChanged();
        }
    }

    default public void performUpdate(class_3222 player) {
    }

    default public void performUpdate() {
    }

    @Override
    default public void markDataChanged() {
        ILootrSavedData data = LootrAPI.getData(this);
        if (data != null) {
            data.markChanged();
        }
    }

    default public class_243 getParticleCenter() {
        class_2338 pos = this.getInfoPos();
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    default public double getParticleYOffset() {
        return 0.95;
    }

    default public double[] getParticleXBounds() {
        return new double[]{0.25, 0.75};
    }

    default public double[] getParticleZBounds() {
        return new double[]{0.25, 0.75};
    }
}

